import Head from "next/head";
import { ErrorComponent } from "@blitzjs/next";
import { gSSP } from "app/blitz-server";
import getShortUrl from "app/short-urls/queries/getShortUrl";
import recordHit from "app/hit-counters/serverSideQueries/recordHit";

export const getServerSideProps = gSSP(async ({ params, ctx }) => {
  const noRedirect = { props: {} };
  if (!params || !params.id) {
    return noRedirect;
  }
  let id = params.id;
  if (id instanceof Array) {
    if (id[0] == undefined) {
      return noRedirect;
    }
    id = id[0];
  }
  const shortUrl = await getShortUrl({ id }, ctx);

  if (shortUrl && shortUrl.active) {
    try {
      await recordHit({ id }, ctx);
    } catch (e) {
      // Not great, but at least we proceed with redirect
      console.error(e);
    }
    return {
      redirect: {
        destination: shortUrl.url,
        permanent: false,
      },
    };
  }

  return noRedirect;
});

export default function ShortUrlNotFound() {
  const statusCode = 404;
  const title = "Short URL not found";
  return (
    <>
      <Head>
        <title>
          {statusCode}: {title}
        </title>
      </Head>
      <ErrorComponent statusCode={statusCode} title={title} />
    </>
  );
}
